/* - MCDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class MCDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JTextField currVelTxt;
    private JTextField maxVelTxt;
    private JTextField accelTxt;
    private JTextField currentTxt;
    private JComboBox motorCmb;
    private JSlider maxVelScrl;
    private JSlider accelScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel10;
    
    /** Creates a new instance of MCDetachListener */
    public MCDetachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, 
            JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JTextField numInTxt,
            JTextField currVelTxt, JTextField maxVelTxt, JTextField accelTxt, 
            JLabel jLabel10, JTextField currentTxt, JComboBox motorCmb, JSlider maxVelScrl, 
            JSlider accelScrl, JCheckBox inputArray[])
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.currVelTxt = currVelTxt;
        this.maxVelTxt = maxVelTxt;
        this.accelTxt = accelTxt;
        this.jLabel10 = jLabel10;
        this.currentTxt = currentTxt;
        this.motorCmb = motorCmb;
        this.maxVelScrl = maxVelScrl;
        this.accelScrl = accelScrl;
        this.inputArray = inputArray;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            MotorControlPhidget detached = (MotorControlPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numMotorsTxt.setText("");
            numInTxt.setText("");
            currVelTxt.setText("");
            maxVelTxt.setText("");
            accelTxt.setText("");
            
            jLabel10.setVisible(false);
            currentTxt.setText("");
            currentTxt.setVisible(false);
            
            motorCmb.setEnabled(false);
            motorCmb.setSelectedIndex(0);
            motorCmb.removeAllItems();
            
            
            int i;
            for(i = 0; i < 4; i++)
            {
                inputArray[i].setVisible(false);
            }
            
            maxVelScrl.setEnabled(false);
            accelScrl.setEnabled(false);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
